class BuildQueue < ActiveRecord::Base
  belongs_to :project

  def out_queue
    mark_as_processed
    the_build = Build.new(:project_id => self.project_id, :category => @category, :status => "building")
    the_build.start_time = Time.now
    the_build.save
    return the_build
  end

  def mark_as_processed
    self.status = "processed"
    self.updated_at = Time.now
    self.save
  end


end