class CreateProjects < ActiveRecord::Migration[4.2]
  def self.up
		create_table "projects", :force => true do |t|
	    t.string   "name"
	    t.string   "identifier"
	    t.string   "project_dir"
	    t.string   "working_dir"
	    t.datetime "created_at"
	    t.boolean  "ui_tests"
	    t.boolean  "grid_ui_tests"
	  end
	
	  add_index "projects", ["identifier"], :unique => true
	  add_index "projects", ["name"]
	
  end

  def self.down
    drop_table :projects
  end
end
