
require "httparty"

module Buildwise
  class App
    module AdminHelper

      def local_gems
        require 'rubygems'
        begin
          Gem::Specification.sort_by{ |g| [g.name.downcase, g.version] }.group_by{ |g| g.name }
        rescue => e
          puts "failed to load gems: #{e}"
        end
      end


      def retrieve_buildwise_version_json
        begin
          response = HTTParty.get("https://agileway.com.au/api/version")
          json_obj = JSON.parse(response.body)
          return json_obj["buildwise"]
        rescue => e
          puts e
          return nil
        end
      end


      def download_file_httparty(url, file_path)
        File.open(file_path, "wb") do |f| 
          f.write HTTParty.get(url).parsed_response
        end
      end

      def download_file_openuri(url, file_path)
        File.open(file_path, "wb") do |saved_file|

          open(url, "rb") do |read_file|
            saved_file.write(read_file.read)
          end
        end
      end


    end

    helpers AdminHelper
  end
end