class CreateBuildQueues < ActiveRecord::Migration[4.2]
  def self.up
	  create_table "build_queues", :force => true do |t|
	    t.integer  "project_id"
	    t.string   "status",     :default => "pending"
	    t.string   "category",   :default => "poll"
	    t.datetime "created_at"
	    t.datetime "updated_at"
	    t.string   "pid"
	  end

	  add_index "build_queues", ["category"]
	  add_index "build_queues", ["status"]
		add_index "build_queues", ["project_id"]
  end

  def self.down
    drop_table :build_queues
  end
end
