class CreateTestCases < ActiveRecord::Migration[4.2]
  def self.up
	  create_table "test_cases", :force => true do |t|
	    t.integer   "test_file_id"
	    t.string    "name"
	    t.float     "duration"
	    t.text      "failure"
	    t.text      "error"
	    t.text      "output"
	    t.text      "scripts"
	    t.boolean   "successful"
	    t.timestamp "created_at",   :null => false
	  end

		add_index "test_cases", ["test_file_id"]
  end

  def self.down
    drop_table :test_cases
  end
end
