















require 'childprocess'

module Buildwise
  class App < Padrino::Application
    use ConnectionPoolManagement
    register Padrino::Mailer
    register Padrino::Helpers
    register Padrino::Cookies
    register Padrino::Cache

    use Rack::Deflater







    enable :caching
    enable :sessions



























    set :logging, true            # Logging in STDOUT for development and file for production (default only for development)









    layout :bs5










    configure do


      global_settings_file = File.join(BUILDWISE_HOME,"setting.yml")
      settings_yml_obj = YAML.load(File.read(global_settings_file)) if File.exist?(global_settings_file)
      settings_yml_obj ||= {}

      the_locale = settings_yml_obj[:locale] ? settings_yml_obj[:locale] : "en"

      set :locale, the_locale.to_sym
      set :company_name, settings_yml_obj[:company_name] ||  ""
      set :max_test_file_history, settings_yml_obj[:max_test_file_history] || 30
      set :dynamic_chart_refresh_interval, settings_yml_obj[:dynamic_chart_refresh_interval] || 5000

      set :num_projects_per_page, settings_yml_obj[:num_projects_per_page] || 5

      set :testwise_integration, settings_yml_obj[:testwise_integration] ? settings_yml_obj[:testwise_integration].to_s == "true" : false
      set :chart_height, settings_yml_obj[:chart_height] ? settings_yml_obj[:chart_height] : 480
      set :hide_test_script_content, settings_yml_obj[:hide_test_script_content] ? settings_yml_obj[:hide_test_script_content].to_s == "true" : false
      
      set :server_api_key, settings_yml_obj[:server_api_key] ? settings_yml_obj[:server_api_key] : ""
      
      set :semaphore, Mutex.new

      set :troubled_agents, {}     
      

      logger.info("Server #{SERVER_DIGEST} is starting ...")       
    end

    before do
      I18n.locale = settings.locale 
    end

    get "/" do
      if Project.count == 0 && current_user.nil?
        redirect "/login"
      else
        redirect "/projects"
      end
    end
    

    get "/status" do
      return "OK"
    end
    

    error 404 do
      render 'errors/404'
    end
  
    error 500 do
      render 'errors/500'
    end
  
  end
end