class DurationFormatter
    def initialize(duration)
      @duration = duration
      @minutes, @seconds = duration.divmod(60)
      @hours, @minutes = @minutes.divmod(60)
      @days, @hours = @hours.divmod(24)
      @years, @days = @days.divmod(365)
    end
  
    def general
      if @years >= 1
        "#{@years} #{years_label} #{@days} #{days_label}"
      elsif @days >= 1
        "#{@days} #{days_label} #{@hours} #{hours_label}"
      elsif @hours >= 1 and @minutes == 0
        "#{@hours} #{hours_label}"
      elsif @hours >= 1
        "#{@hours} #{hours_label} #{@minutes} #{minutes_label}"
      elsif @minutes >= 1
        "#{@minutes} #{minutes_label}"
      else
        "#{@seconds} #{seconds_label}"
      end
    end
  
    def precise
      result = []
      result << "#{@days} #{days_label}" unless @days == 0
      result << "#{@hours} #{hours_label}" unless @hours == 0
      result << "#{@minutes} #{minutes_label}" unless @minutes == 0
      result << "#{@seconds} #{seconds_label}" unless @seconds == 0 and @duration != 0
      result.join(" and ")
    end
  
    def years_label
      @years == 1 ? I18n.t(:year) : I18n.t(:years) 
    end
  
    def days_label
      @days == 1 ?  I18n.t(:day) : I18n.t(:days) 
    end
  
    def hours_label
      @hours == 1 ?  I18n.t(:hour) : I18n.t(:hours) 
    end
  
    def minutes_label
      @minutes == 1 ? I18n.t(:minute) : I18n.t(:minutes)
    end
  
    def seconds_label
      @seconds == 1 ? I18n.t(:second) : I18n.t(:seconds)
    end
  
    def method_missing(format, *args)
      raise "Unknown duration format #{format.inspect}"
    end
  end
  