

class SpecContext

  attr_accessor :name
  attr_accessor :start_line
  attr_accessor :end_line
  attr_accessor :spec_behaviours

  attr_reader :spec_file

  attr_accessor :before_each_line_start, :before_all_line_start, :after_each_line_start, :after_all_line_start
  attr_accessor :first_test_case_line_start
  
  def initialize(name, spec_file)
    @name = name.strip
    @spec_file =  spec_file
    @spec_behaviours = []
  end

  def display_name
    @name
  end

  def source
    lines.join()
  end

  def lines
    @spec_file.lines[(start_line-1)..(end_line-1)]
  end

  def file_path
    @spec_file.file_path
  end

  def normalize
    empty_lines_after_count = 0;
    @end_line.downto(@start_line) do |line_no|
      line = @spec_file.lines[line_no-1]
      if line.nil? || line.strip.empty?
        empty_lines_after_count += 1
      else
        break
      end
    end
    @end_line -= empty_lines_after_count
  end

  def first_test_case_start_line
    first_line = -1
    spec_behaviours.each do |test_case|
      first_line = test_case.start_line if test_case.start_line < first_line || first_line < 0
    end
    return first_line
  end

end