class CreateBuilds < ActiveRecord::Migration[4.2]
  def self.up
	  create_table "builds", :force => true do |t|
	    t.string   "label"
	    t.string   "status"
	    t.string   "stage"
	    t.string   "category"
	    t.boolean  "successful"
	    t.integer  "project_id"
	    t.integer  "unit_test_num_total",                     :default => 0
	    t.integer  "unit_test_num_errors"
	    t.integer  "unit_test_num_failures"
	    t.float    "unit_test_duration"
	    t.string   "ui_test_status"
	    t.datetime "created_at"
	    t.datetime "start_time"
	    t.datetime "finish_time"
	    t.text     "backtrace"
	    t.text     "output"
	    t.text     "builder_output"
	    t.string   "artifacts_dir"
	    t.string   "changeset_log"
	    t.string   "revision"
	    t.string   "pid"
	    t.string   "last_author"
	    t.datetime "last_commit_date"
	    t.string   "last_commit_message"
	    t.text     "acceptance_test_options"
	    t.text     "acceptance_test_context_to_file_lookups"
	    t.boolean  "distributed"
	    t.text     "last_commit_changed_files"
	    t.float    "duration"
	    t.string   "test_framework"
	  end

	  add_index "builds", ["project_id"]
	  add_index "builds", ["status"]

  end

  def self.down
  end
end
