class CreateTestFiles < ActiveRecord::Migration[4.2]
  def self.up
	  create_table "test_files", :force => true do |t|
	    t.integer  "build_id"
	    t.string   "filename"
	    t.string   "result_filename"
	    t.string   "description"
	    t.string   "category"
	    t.string   "status"
	    t.string   "agent"
	    t.string   "past_agents"
	    t.integer  "num_total"
	    t.integer  "num_errors"
	    t.integer  "num_failures"
	    t.text     "stdout"
	    t.text     "stderr"
	    t.float    "duration"
	    t.string   "result"
	    t.string   "log_file"
	    t.string   "result_file"
	    t.text     "comments"
	    t.datetime "last_modified"
	    t.datetime "created_at"
	    t.datetime "assigned_at"
	    t.integer  "priority"
	    t.boolean  "successful"
	    t.string   "file_path"
	  end

		add_index "test_files", ["build_id"]
		add_index "test_files", ["filename"]
		add_index "test_files", ["priority"]
		add_index "test_files", ["status"]
  end

  def self.down
    drop_table :test_files
  end
end
