class CreateDistributionRules < ActiveRecord::Migration[4.2]
  def self.up
	  create_table "distribution_rules", :force => true do |t|
	    t.integer   "project_id"
	    t.string    "test_file_names"
      t.string    "build_agent_names"
	    t.string    "constraint" # only_on, same_agent
      t.boolean   "active", :default => true
	    t.timestamp "created_at",   :null => false
	  end

    add_index "distribution_rules", :project_id    
  end

  def self.down
    drop_table :distribution_rules
  end
end
