class CreateUsers < ActiveRecord::Migration[4.2]
  def self.up
	  create_table "users", :force => true do |t|
	    t.string   "username"
	    t.string   "email"
	    t.string   "password_digest"
	    t.string   "password_reset_token"
      t.datetime "password_reset_sent_at"
      t.string   "locale"
      t.timestamps
	  end    
    
    add_index :users, :username
    add_index :users, :email
  end

  def self.down
    drop_table :users
  end
end
