class CreateBuildStepExecutions < ActiveRecord::Migration[4.2]
  def self.up
	  create_table "build_step_executions", :force => true do |t|
	    t.integer  "build_id"
	    t.string   "task_name"
	    t.boolean  "successful", :default => true
	    t.integer  "exit_status"
      t.timestamp "start_time"
      t.timestamp "end_time"      
      t.decimal "duration"  
      t.string  "log_file"
      t.boolean :is_ui_test, :default => false
	    t.text     "output"
	  end    
    
  end

  def self.down
    drop_table :build_step_executions
  end
  
end
