class CreateLoadTestResults < ActiveRecord::Migration[4.2]  
  def change  
	  create_table "load_test_results", :force => true do |t|
	    t.integer   :build_id
	    t.string    :agent_name
	    t.string    :operation
      t.bigint    :start_timestamp # e.g. 1586950082
      t.bigint    :end_timestamp # e.g. 1586950082
      t.bigint    :duration
      t.boolean   :success, :default => false
      t.text      :error
	  end
    
    add_index :load_test_results, :build_id
    add_index :load_test_results, :operation
    add_index :load_test_results, [:agent_name, :start_timestamp, :operation], name: "load-test-results-key", unique: true
    
  end
end