class CreatePerformanceTestResults < ActiveRecord::Migration[4.2]  
  def change  
	  create_table "performance_test_results", :force => true do |t|
	    t.integer   :build_id, null: false
      t.integer   :test_file_id
	    t.string    :operation, null: false
      t.timestamp :starts_at # rough estimate 
      t.decimal   :duration, precision: 8, scale: 3
	  end
    
    add_index :performance_test_results, :build_id
    add_index :performance_test_results, :operation    
  
    add_column :builds, :is_performance_testing, :boolean, :default => false
    
  end
end