module BuildWise
  module Builder
    class Base
      attr_accessor :name
      attr_accessor :log_file
      attr_reader :output      
    
      def initialize(config, name)
        @config = config
        @name = name
      end
      
      def output
        @output
      end
    
      def builder_symbol
        @name.to_sym
      end

      def update_build_stage(active_build, task_name)
        if active_build && task_name
          active_build.stage = task_name
          active_build.save
        end
      end

    end
  end
end


